{------------------------------------------------------------------------------}
{- Program    : DT2UTIME.PAS                                                  -}
{- Programmer : Todd Fiske                                                    -}
{-                                                                            -}
{- Purpose    : Convert date and time to a unix number of seconds             -}
{-                                                                            -}
{- Revision   : 02/17/1994 - first version                                    -}
{- History      01/16/1995 - cleaned up for uploading                         -}
{-                                                                            -}
{- Language   : Turbo Pascal 7.0                                              -}
{-                                                                            -}
{------------------------------------------------------------------------------}
program dt2utime;

uses
   dos,
   unixtime;

var
   t : longint;
   d : DateTime;

{------------------------------------------------------------------------------}
{- Date and time to seconds test                                              -}
{------------------------------------------------------------------------------}
begin
   writeln;
   writeln('DT 2 UnixTime');

   if paramcount = 0 then begin
      writeln;
      writeln('dt2utime <mm/dd/[cc]yy> [<hh:mm:ss>]');
      halt;
   end;

   writeln;
   writeln('Packing Unix time longint');

   d.year  := str2int( copy(paramstr(1), 7, 4) );
   d.month := str2int( copy(paramstr(1), 1, 2) );
   d.day   := str2int( copy(paramstr(1), 4, 2) );

   d.hour  := str2int( copy(paramstr(2), 1, 2) );
   d.min   := str2int( copy(paramstr(2), 4, 2) );
   d.sec   := str2int( copy(paramstr(2), 7, 2) );

   if d.year < 100 then begin                    { if century not specified }
      if d.year < 50 then                        { if low decade }
         inc(d.year, 2000)                       { assume next century }
      else
         inc(d.year, 1900);                      { else assume this century }
   end;

   writeln;
   writeln('year      : ', d.year  : 4);
   writeln('month     : ', d.month : 4);
   writeln('day       : ', d.day   : 4);
   writeln('hour      : ', d.hour  : 4);
   writeln('minute    : ', d.min   : 4);
   writeln('second    : ', d.sec   : 4);

   writeln;
   PackUnixTime(d, t);
   writeln('repacked  : ', t);
end.
